IF  EXISTS (SELECT 1 FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'UFD_FORMATAR_CNPJCPF') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
   DROP FUNCTION [dbo].[UFD_FORMATAR_CNPJCPF]
GO 
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20230929
'Job.................:  
'Nome................: UFD_FORMATAR_CNPJCPF
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2023-09-29
'Alterado por........: Marcos Barros
'Criado por..........: Jean Carlos
'=======================================================================================
OBS: Usado na view [V_GLB_PESSOA_BENNER]
*/

CREATE FUNCTION UFD_FORMATAR_CNPJCPF (@CnpjCpf varchar(18))
RETURNS VARCHAR(18)
AS
BEGIN
   DECLARE @retorno VARCHAR(18)
      
   SET @CnpjCpf = REPLACE(REPLACE(REPLACE(@CnpjCpf,'.', ''),'-', ''),'/', '') 
      
   IF LEN(@CnpjCpf)= 14 --CNPJ
      BEGIN
         SET @retorno = substring(@CnpjCpf ,1,2) + '.' + substring(@CnpjCpf ,3,3) + '.' + substring(@CnpjCpf ,6,3) + '/' + substring(@CnpjCpf ,9,4) + '-' + substring(@CnpjCpf ,13,2)
      END
   ELSE IF LEN(@CnpjCpf)= 11 --CNPJ
      BEGIN
         SET @retorno = substring(@CnpjCpf ,1,3) + '.' + substring(@CnpjCpf ,4,3) + '.' + substring(@CnpjCpf ,7,3) + '-' + substring(@CnpjCpf ,10,2) 
      END
   ELSE 
      BEGIN 
      	SET @retorno = @CnpjCpf 
      END

   RETURN @retorno
END
